

<?php $__env->startSection('title', 'All Prescriptions'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">All Prescriptions</h1>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back to Dashboard</span><span class="sm:hidden">Back</span>
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Prescription #</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden sm:table-cell">Doctor</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Diagnosis</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Items</th>
                    <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $prescriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prescription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="font-medium text-sm sm:text-base"><?php echo e($prescription->prescription_number); ?></span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <div>
                            <div class="font-medium text-sm sm:text-base"><?php echo e($prescription->patient->full_name); ?></div>
                            <div class="text-xs sm:text-sm text-gray-500"><?php echo e($prescription->patient->patient_id); ?></div>
                        </div>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden sm:table-cell">
                        <span class="text-sm"><?php echo e($prescription->doctor->full_name ?? 'N/A'); ?></span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="text-xs sm:text-sm"><?php echo e($prescription->created_at->format('M d, Y')); ?></span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 hidden md:table-cell">
                        <span class="text-xs sm:text-sm"><?php echo e($prescription->diagnosis ?? 'N/A'); ?></span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                        <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded text-xs">
                            <?php echo e($prescription->items->count()); ?> item(s)
                        </span>
                    </td>
                    <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-xs sm:text-sm font-medium">
                        <div class="flex flex-col sm:flex-row gap-1 sm:gap-2">
                            <a href="<?php echo e(route('prescriptions.show', $prescription->id)); ?>" class="text-blue-600 hover:text-blue-900">
                                <i class="fas fa-eye"></i> <span class="hidden sm:inline">View</span>
                            </a>
                            <a href="<?php echo e(route('prescriptions.download', $prescription->id)); ?>" class="text-green-600 hover:text-green-900">
                                <i class="fas fa-download"></i> <span class="hidden sm:inline">Download</span>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                        No prescriptions found.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        </div>
    </div>

    <?php if($prescriptions->count() > 0): ?>
    <div class="mt-4 text-sm text-gray-600">
        Showing <?php echo e($prescriptions->count()); ?> prescription(s)
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/admin/prescriptions.blade.php ENDPATH**/ ?>